# -*- coding: utf-8 -*-
"""
Daniel Calderon S.

file: mix2D3D.py
----------------------------
Dibuja un cubo rotando en 3D y luego cambia
el modo de dibujo a 2D y dibuja un cuadrado
de colores (incluyendo transparencia y degradaciones)
en la posición del mouse.

Control del programa:
1: Visualiza o no los ejes de coordenadas
2: Pinta o no los polígonos
ESC: terminar
"""

import pygame
from pygame.locals import *

from OpenGL.GL import *
from OpenGL.GLU import *
from OpenGL.GLUT import *

from AuxiliaryFunctions import *

#####################################################################

def init_pygame((w,h), title=""):
    pygame.init()
    pygame.display.set_mode((w,h), OPENGL|DOUBLEBUF)
    pygame.display.set_caption(title)

def init_opengl3D((w,h)):
    reshape3D((w,h))
    init3D()
 
def init3D():
    # setea el color de fondo
    glClearColor(0.5, 0.5, 0.5, 1.0)
    
    # se habilitan las transparencias
    glEnable(GL_BLEND)
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
    # el color debe incluir la cuarta componente, alpha
    # alpha=1  --> objeto totalmente opaco
    # alpha=0  --> opbjeto totalmente transparente
 
    glEnable(GL_DEPTH_TEST)
    glDepthFunc(GL_LEQUAL)
    #glDepthFunc(GL_LESS)    
        
#    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    
    # normaliza las normales luego del escalamiento.
    glEnable(GL_NORMALIZE)
    
def reshape3D((width, height)):
    if height == 0:
        height = 1
    glViewport(0, 0, width, height)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluPerspective(60.0, float(width)/float(height), 0.1, 20000.0)
    #glOrtho(-2*width,2*width,-2*height,2*height,1,20000)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    
def init_opengl2D((w,h)):
    init2D()
    reshape2D((w,h))
    
def init2D():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glShadeModel(GL_SMOOTH)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    glEnable (GL_BLEND)
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
    glHint (GL_LINE_SMOOTH_HINT, GL_NICEST)

def reshape2D((width, height)):
    if height == 0:
        height = 1
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluOrtho2D(0.0, width, 0.0, height)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

#####################################################################

def initLight():
    
    glLightfv(GL_LIGHT0, GL_POSITION, [ 3000.0, 0.0, 0.0, 1.0 ])
    glLightfv(GL_LIGHT0, GL_AMBIENT , [ 0.2, 0.2, 0.2, 1.0])
    glLightfv(GL_LIGHT0, GL_SPECULAR, [ 1.0, 1.0, 1.0, 1.0])
    glLightfv(GL_LIGHT0, GL_DIFFUSE , [ 1.0, 1.0, 1.0, 1.0])
 
    glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 1.0)
    glLightf(GL_LIGHT0, GL_LINEAR_ATTENUATION, 0.0)
    glLightf(GL_LIGHT0, GL_QUADRATIC_ATTENUATION, 0.0)
 
    glLightf(GL_LIGHT0, GL_SPOT_CUTOFF, 180.0)
    glLightfv(GL_LIGHT0, GL_SPOT_DIRECTION, [ -1.0, 0.0, 0.0])
    glLightf(GL_LIGHT0, GL_SPOT_EXPONENT, 0.0)
 
    glEnable(GL_LIGHT0)

#####################################################################

def listaCuboFlat():
    
    a = [-0.5,-0.5,-0.5]
    b = [ 0.5,-0.5,-0.5]
    c = [ 0.5,-0.5, 0.5]
    d = [-0.5,-0.5, 0.5]
    e = [-0.5, 0.5,-0.5]
    f = [ 0.5, 0.5,-0.5]
    g = [ 0.5, 0.5, 0.5]
    h = [-0.5, 0.5, 0.5]
    
    n1 = [0,-1,0]
    n2 = [1,0,0]
    n3 = [0,1,0]
    n4 = [-1,0,0]
    n5 = [0,0,1]
    n6 = [0,0,-1]
    
    lista = glGenLists(1)
    glNewList(lista, GL_COMPILE)
    
    glBegin(GL_QUADS)
    
    draw4Vertexfvn(a,b,c,d,n1)
    draw4Vertexfvn(b,f,g,c,n2)
    draw4Vertexfvn(f,e,h,g,n3)
    draw4Vertexfvn(e,a,d,h,n4)
    draw4Vertexfvn(d,c,g,h,n5)
    draw4Vertexfvn(a,e,f,b,n6)
    
    glEnd()
    
    glEndList()
    
    return lista

def listaQuadColors():
    
    a = [-0.5,-0.5]
    b = [ 0.5,-0.5]
    c = [ 0.5,0.5]
    d = [-0.5,0.5]
    
    lista = glGenLists(1)
    glNewList(lista, GL_COMPILE)
    
    glBegin(GL_QUADS)
    
    glColor4f(1,0,0,0)
    glVertex2fv(a)
    glColor4f(0,1,0,0.25)
    glVertex2fv(b)
    glColor4f(0,0,1,0.5)
    glVertex2fv(c)
    glColor4f(1,1,0,1)
    glVertex2fv(d)
    
    glEnd()
    
    glEndList()
    
    return lista

#####################################################################

W=640 #ancho de ventana
H=480 #alto de ventana

# inicializando ...
init_pygame((W,H),"mix2D3D")
init_opengl3D((W,H))

# imprime información sobre el Hardware gráfico y
# la version de OpenGL implementada
printVersions()

# creación de dibujos en listas
cubo = listaCuboFlat()
fig = listaQuadColors()

axes = axesList(100000)
 
# variables del programa
o = 30
w = 0.1
px = 0.0
py = 0.0

show_axes = True
fill_polygons = True

# configura fuentes de luz
initLight()

# medida de tiempo inicial
t0 = pygame.time.get_ticks()

run = True
while run:
    # 0: CONTROL DEL TIEMPO
    t1 = pygame.time.get_ticks()    # tiempo actual
    dt = (t1 - t0)                  # diferencial de tiempo asociado a la iteración
    t0 = t1                         # actualizar tiempo inicial para siguiente iteración
 
 
    # 1: MANEJAMOS EVENTOS DE ENTRADA (TECLADO, MOUSE, ETC.)
    for event in pygame.event.get():
        
        mouse_pos=pygame.mouse.get_pos()
        px = mouse_pos[0]
        py = H - mouse_pos[1]
        
        if event.type == QUIT:
            run = False
        if event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                run = False
            if event.key == K_1:
                show_axes = not show_axes
            if event.key == K_2:
                fill_polygons = not fill_polygons
                
    # 2: EJECUTAMOS LOGICA DE LA APLICACION
    o += w*dt
    
    # 3: DIBUJAMOS LOS ELEMENTOS
    
    init_opengl3D((W,H))
#    glEnable(GL_LIGHTING)
    
    # limpia la pantalla (buffer de color y de profundidad)
    glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT)
    
    #posibilidad de pintar o no los polígonos
    if fill_polygons:
        glPolygonMode(GL_FRONT, GL_FILL)
        glPolygonMode(GL_BACK, GL_FILL)
    else:
        glPolygonMode(GL_FRONT, GL_LINE)
        glPolygonMode(GL_BACK, GL_LINE)
        
    # Dibujos en 3D
        
    init_opengl3D((W,H))
    glEnable(GL_LIGHTING)
        
    glLoadIdentity()
    gluLookAt( 2000.0, 1000.0, 2000.0, \
               0.0, 0.0, 0.0, \
               0.0, 0.0, 1.0)
    
    # posibilidad de mostrar o no los ejes
    if show_axes:
        glDisable(GL_LIGHTING)
        glCallList(axes)
        glEnable(GL_LIGHTING)
    
    glMaterialfv(GL_FRONT, GL_AMBIENT, [0.0,0.0,0.0,1.0])
    glMaterialfv(GL_FRONT, GL_DIFFUSE, [1.0,0.0,0.0,1.0])
    glMaterialfv(GL_FRONT, GL_SPECULAR,[1.0,1.0,1.0,1.0])
    glMaterialfv(GL_FRONT, GL_SHININESS, [10.0])
    glMaterialfv(GL_FRONT, GL_EMISSION, [0.0,0.0,0.0,1.0])
    
    glShadeModel(GL_FLAT)    
    drawList(cubo,pos = [0,0,0],o = o,rot = [0,1,0],sz = [700,700,700])
    
    glShadeModel(GL_SMOOTH)
    
    # Dibujos en 2D
    init_opengl2D((W,H))
    glDisable(GL_LIGHTING)
    drawList(fig,pos = [px,py,0],o = 3*o,rot = [0,0,1],sz = [100,150,0])
    
    pygame.display.flip()       # vuelca el dibujo a la pantalla
    #pygame.time.wait(1000/30)   # ajusta para trabajar a 30 fps.

#####################################################################
